if RequiredScript == "lib/network/base/networkpeer" then
	
	-- is this a good function to hook onto for this? seems like it
	Hooks:PostHook(NetworkPeer,"verify_outfit","MarkSkillPointCheaters_verifyoutfit",function(self, result, reason, ...)
		if not self._susSP then
			self:verify_skillpoints()
		end
	end)

	function NetworkPeer:verify_skillpoints()
		local skills = self:unpacked_skills().skills
		local pointTotal = 0
		-- I know someone that obscures their illegal point total by sending all 6's
		-- This can detect it, but not autokick for it, in case someone has the dumbest build of all time
		local allTheSame = true
		local firstTree = skills[1]
		for _,v in ipairs(skills) do
			pointTotal = pointTotal + v
			if v ~= firstTree then allTheSame = false end
		end
		if pointTotal > 120 then
			self:mark_cheater(121, Network:is_server())
			self._susSP = true
		elseif allTheSame and pointTotal > 0 then
			managers.chat:feed_system_message(ChatManager.GAME, self:name() .. " might be cheating by obscuring their skill points.")
			self._susSP = true
		end
	end

elseif RequiredScript == "lib/managers/votemanager" then
	local orig_kick_reason = VoteManager.kick_reason_to_string
	function VoteManager:kick_reason_to_string(reason)
		if reason == 121 then return "menu_chat_peer_cheated_many_skillpoints"
		else return orig_kick_reason(self, reason) end
	end
elseif RequiredScript == "lib/managers/localizationmanager" then
	Hooks:Add("LocalizationManagerPostInit", "MarkSkillPointCheaters_locinit", function(loc)
		LocalizationManager:add_localized_strings({
			menu_chat_peer_cheated_many_skillpoints = "$name; cheated by having too many skill points.",
		})
	end)
end